<?php
/**
  *最新更新文章列表
  */

$num = _hui('recently_updated_posts_num');
$days = _hui('recently_updated_posts_days');
function recently_updated_posts($num = 5,$days = 7) {	
   if( !$recently_updated_posts = get_option('recently_updated_posts') ) {
	    $i=0;
        $args = array(			
			'post__not_in' =>get_option('sticky_posts'),
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'orderby'=> 'modified',
			);	   
        query_posts($args);
        while ( have_posts() && $i < $num ) : the_post();
            if (current_time('timestamp') - get_the_time('U') > 60*60*24*$days) {
                $i++;
				
				$t1=get_the_modified_date("Y-m-d H:i:s");
				$t2=date("Y-m-d H:i:s");
				$diff=(strtotime($t2)-strtotime($t1))/86400;
				if( $diff < 1){ 
					$color = red;
				 } else {
					$color = "";
				 }				
				
                $the_title_value = get_the_title(); 
				$recently_updated_posts.= '<li style="color:'.$color.';"><a style="color:'.$color.';" href="'.get_permalink().'" title="'.$the_title_value.'">'.$the_title_value.'</a><span style="color:'.$color.';"> 更新于：'.get_the_modified_time('Y.m.d').'</span></li>';
           }
        endwhile;
        wp_reset_query();
        if ( !empty($recently_updated_posts) ) update_option('recently_updated_posts', $recently_updated_posts);
   }
   $recently_updated_posts = ($recently_updated_posts == '') ? '<li>暂无最新更新文章</li>' : $recently_updated_posts;
   echo '<div class="posts_list_block">
            <div class="title"><h3>'._hui('recently_updated_posts_title').'</h3></div>
            <div class="posts_list_block_bg"><ul>'.$recently_updated_posts.'</ul></div>
        </div>';
}
recently_updated_posts($num,$days);

?>